<?php

/**
 * This file is part of OPUS. The software OPUS has been originally developed
 * at the University of Stuttgart with funding from the German Research Net,
 * the Federal Department of Higher Education and Research and the Ministry
 * of Science, Research and the Arts of the State of Baden-Wuerttemberg.
 *
 * OPUS 4 is a complete rewrite of the original OPUS software and was developed
 * by the Stuttgart University Library, the Library Service Center
 * Baden-Wuerttemberg, the Cooperative Library Network Berlin-Brandenburg,
 * the Saarland University and State Library, the Saxon State Library -
 * Dresden State and University Library, the Bielefeld University Library and
 * the University Library of Hamburg University of Technology with funding from
 * the German Research Foundation and the European Regional Development Fund.
 *
 * LICENCE
 * OPUS is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the Licence, or any later version.
 * OPUS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with OPUS; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @category    Application
 * @author      Ralf Claussnitzer (ralf.claussnitzer@slub-dresden.de)
 * @author      Thoralf Klein <thoralf.klein@zib.de>
 * @copyright   Copyright (c) 2008-2010, OPUS 4 development team
 * @license     http://www.gnu.org/licenses/gpl.html General Public License
 * @version     $Id: index.php 10347 2012-06-12 14:02:40Z tklein $
 */

// Saving start time for profiling.
$GLOBALS['start_mtime'] = microtime(true);

// Define path to application directory
defined('APPLICATION_PATH')
        || define('APPLICATION_PATH', realpath(dirname(dirname(__FILE__))));

// Define application environment (use 'production' by default)
defined('APPLICATION_ENV')
        || define('APPLICATION_ENV',
        (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'production'));

// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
            realpath(dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'library'),
            get_include_path(),
        )));

///** Zend_Application */
require_once 'Zend/Application.php';
require_once 'Zend/Config/Ini.php';

$config = new Zend_Config_Ini(
        APPLICATION_PATH . '/application/configs/application.ini',
        APPLICATION_ENV,
        array('allowModifications'=>true));

$localConfig = new Zend_Config_Ini(
        APPLICATION_PATH . '/application/configs/config.ini',
        APPLICATION_ENV,
        array('allowModifications'=>true));

$config->merge($localConfig);

//// Create application, bootstrap, and run
$application = new Zend_Application(APPLICATION_ENV, $config);

try {
    $application->bootstrap()->run();
}
catch (Exception $e) {
    if (APPLICATION_ENV === 'production') {
        header("HTTP/1.0 500 Internal Server Error");
        echo $e->getMessage();
    }
    else {
        throw $e;
    }
}

