<?php

/**
 * This file is part of OPUS. The software OPUS has been originally developed
 * at the University of Stuttgart with funding from the German Research Net,
 * the Federal Department of Higher Education and Research and the Ministry
 * of Science, Research and the Arts of the State of Baden-Wuerttemberg.
 *
 * OPUS 4 is a complete rewrite of the original OPUS software and was developed
 * by the Stuttgart University Library, the Library Service Center
 * Baden-Wuerttemberg, the Cooperative Library Network Berlin-Brandenburg,
 * the Saarland University and State Library, the Saxon State Library -
 * Dresden State and University Library, the Bielefeld University Library and
 * the University Library of Hamburg University of Technology with funding from
 * the German Research Foundation and the European Regional Development Fund.
 *
 * LICENCE
 * OPUS is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the Licence, or any later version.
 * OPUS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with OPUS; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @category    Application
 * @package     Module_Publish
 * @author      Susanne Gottwald <gottwald@zib.de>
 * @copyright   Copyright (c) 2008-2010, OPUS 4 development team
 * @license     http://www.gnu.org/licenses/gpl.html General Public License
 * @version     $Id: FileOverview.php 10784 2012-11-20 08:47:09Z sszott $
 */
class Publish_View_Helper_FileOverview extends Zend_View_Helper_Abstract {

    public $view;
    public $session;
    public $document;

    /**
     * method to render specific elements of an form
     * @param <type> $type element type that has to rendered
     * @param <type> $value value of element or Zend_Form_Element
     * @param <type> $name name of possible hidden element
     * @return element to render in view
     */
    public function fileOverview() {
        $config = Zend_Registry::get('Zend_Config');
        if (!isset($config->form->first->enable_upload) || $config->form->first->enable_upload != 1) {
            return;
        }

        $this->session = new Zend_Session_Namespace('Publish');

        $fieldset_start = "<fieldset><legend>" . $this->view->translate('already_uploaded_files') . "</legend>\n\t\t\n\t\t";
        $fieldset_end = "</fieldset>";

        if ($this->session->documentId == "") {
            return "";
        }

        $this->document = new Opus_Document($this->session->documentId);
        $files = $this->document->getFile();

        if (empty($files)) {
            return $fieldset_start . "<b>" . $this->view->translate('no_uploaded_files') . "</b>" . $fieldset_end;
        }
        
        $overview = "";

        if ($this->view->uploadSuccess === false) {
                $overview .= "<div class='form-errors'><ul><li>" . $this->view->translate('error_uploaded_files') . "</li></ul></div>";
        }

        foreach ($files as $file) {
            $overview .= '<p>' . $this->view->translate('name') . ': <b>' . htmlspecialchars($file->getPathName()) .
                        '</b><br/>' . $this->view->translate('type') . ': ' . htmlspecialchars($file->getMimeType()) .
                        '<br/>' . $this->view->translate('size') . ': ' . htmlspecialchars($file->getFileSize()) . ' '. $this->view->translate('bytes')  .
                        '<br />' . $this->view->translate('uploadComment') . ': ' . htmlspecialchars($file->getComment()) . '</p>';

        }

        return $fieldset_start . $overview . $fieldset_end;
    }

}

