<?php
/**
 * This file is part of OPUS. The software OPUS has been originally developed
 * at the University of Stuttgart with funding from the German Research Net,
 * the Federal Department of Higher Education and Research and the Ministry
 * of Science, Research and the Arts of the State of Baden-Wuerttemberg.
 *
 * OPUS 4 is a complete rewrite of the original OPUS software and was developed
 * by the Stuttgart University Library, the Library Service Center
 * Baden-Wuerttemberg, the Cooperative Library Network Berlin-Brandenburg,
 * the Saarland University and State Library, the Saxon State Library -
 * Dresden State and University Library, the Bielefeld University Library and
 * the University Library of Hamburg University of Technology with funding from
 * the German Research Foundation and the European Regional Development Fund.
 *
 * LICENCE
 * OPUS is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the Licence, or any later version.
 * OPUS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with OPUS; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @category    Application
 * @package     Module_Oai
 * @author      Sascha Szott <szott@zib.de>
 * @copyright   Copyright (c) 2008-2012, OPUS 4 development team
 * @license     http://www.gnu.org/licenses/gpl.html General Public License
 * @version     $Id: SingleFile.php 10336 2012-06-12 10:49:43Z sszott $
 */

class Oai_Model_SingleFile extends Oai_Model_AbstractFile {    

    public function __construct($docId, $fileToInclude, $filesPath, $tempPath, $logger = null) {
        $this->_logger = $logger;
        $numberOfFiles = count($fileToInclude);
        if ($numberOfFiles != 1) {
            $this->logErrorMessage("unexpected number of files to process: $numberOfFiles");
            throw new Oai_Model_Exception('unexpected number of files to include: only one file was expected');
        }        
        $file = $fileToInclude[0];        
        $filePath = $filesPath . $docId . DIRECTORY_SEPARATOR . $file->getPathName();
        $extension = '.' . pathinfo($filePath, PATHINFO_EXTENSION);
        $outputFile = $tempPath . uniqid($docId, true) . $extension;
        if (!copy($filePath, $outputFile)) {
            $this->logErrorMessage("error while performing copy operation from '$filePath' to '$outputFile'");
            throw new Oai_Model_Exception('error while copying file');
        }
        $this->path = $outputFile;
        $this->mimeType = $file->getMimeType();
        $this->extension = $extension;
    }

}
