<?php
/**
 * This file is part of OPUS. The software OPUS has been originally developed
 * at the University of Stuttgart with funding from the German Research Net,
 * the Federal Department of Higher Education and Research and the Ministry
 * of Science, Research and the Arts of the State of Baden-Wuerttemberg.
 *
 * OPUS 4 is a complete rewrite of the original OPUS software and was developed
 * by the Stuttgart University Library, the Library Service Center
 * Baden-Wuerttemberg, the Cooperative Library Network Berlin-Brandenburg,
 * the Saarland University and State Library, the Saxon State Library -
 * Dresden State and University Library, the Bielefeld University Library and
 * the University Library of Hamburg University of Technology with funding from
 * the German Research Foundation and the European Regional Development Fund.
 *
 * LICENCE
 * OPUS is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the Licence, or any later version.
 * OPUS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with OPUS; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @category    Application
 * @package     Admin_Form
 * @author      Jens Schwidder <schwidder@zib.de>
 * @copyright   Copyright (c) 2008-2014, OPUS 4 development team
 * @license     http://www.gnu.org/licenses/gpl.html General Public License
 * @version     $Id: Collection.php 13401 2014-07-01 15:39:41Z mlang $
 */

class Admin_Form_Collection extends Application_Form_Model_Abstract {

    const ELEMENT_NAME = 'Name';
    const ELEMENT_NUMBER = 'Number';
    const ELEMENT_VISIBLE = 'Visible';
    const ELEMENT_VISIBLE_PUBLISH = 'VisiblePublish';
    const ELEMENT_OAI_SUBSET = 'OaiSubset';
    const ELEMENT_THEME = 'Theme';

    public function init() {
        parent::init();

        $this->setUseNameAsLabel(true);

        $this->addElement('text', self::ELEMENT_NAME, array('size' => 70));
        $this->addElement('text', self::ELEMENT_NUMBER, array('size' => 30));
        $this->addElement('checkbox', self::ELEMENT_VISIBLE);
        $this->addElement('checkbox', self::ELEMENT_VISIBLE_PUBLISH);
        $this->addElement('text', self::ELEMENT_OAI_SUBSET, array('size' => 50));
        $this->addElement('Theme', self::ELEMENT_THEME);

        $this->removeElement('Cancel');
    }

    public function populateFromModel($collection) {
        $this->getElement(self::ELEMENT_MODEL_ID)->setValue($collection->getId());
        $this->getElement(self::ELEMENT_NAME)->setValue($collection->getName());
        $this->getElement(self::ELEMENT_NUMBER)->setValue($collection->getNumber());
        $this->getElement(self::ELEMENT_VISIBLE)->setValue($collection->getVisible());
        $this->getElement(self::ELEMENT_VISIBLE_PUBLISH)->setValue($collection->getVisiblePublish());
        $this->getElement(self::ELEMENT_OAI_SUBSET)->setValue($collection->getOaiSubset());
        $this->getElement(self::ELEMENT_THEME)->setValue($collection->getTheme());
    }

    public function updateModel($collection) {
        $collection->setName($this->getElementValue(self::ELEMENT_NAME));
        $collection->setNumber($this->getElementValue(self::ELEMENT_NUMBER));
        $collection->setVisible($this->getElementValue(self::ELEMENT_VISIBLE));
        $collection->setVisiblePublish($this->getElementValue(self::ELEMENT_VISIBLE_PUBLISH));
        $collection->setOaiSubset($this->getElementValue(self::ELEMENT_OAI_SUBSET));
        $collection->setTheme($this->getElementValue(self::ELEMENT_THEME));
    }

}