<?php

/**
 * This file is part of OPUS. The software OPUS has been originally developed
 * at the University of Stuttgart with funding from the German Research Net,
 * the Federal Department of Higher Education and Research and the Ministry
 * of Science, Research and the Arts of the State of Baden-Wuerttemberg.
 *
 * OPUS 4 is a complete rewrite of the original OPUS software and was developed
 * by the Stuttgart University Library, the Library Service Center
 * Baden-Wuerttemberg, the Cooperative Library Network Berlin-Brandenburg,
 * the Saarland University and State Library, the Saxon State Library -
 * Dresden State and University Library, the Bielefeld University Library and
 * the University Library of Hamburg University of Technology with funding from
 * the German Research Foundation and the European Regional Development Fund.
 *
 * LICENCE
 * OPUS is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the Licence, or any later version.
 * OPUS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with OPUS; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @category    Framework
 * @package     Opus_Model
 * @author      Henning Gerhardt (henning.gerhardt@slub-dresden.de)
 * @author      Thoralf Klein <thoralf.klein@zib.de>
 * @copyright   Copyright (c) 2009-2010, OPUS 4 development team
 * @license     http://www.gnu.org/licenses/gpl.html General Public License
 * @version     $Id: Conf.php 8424 2011-05-27 17:00:09Z sszott $
 */

/**
 * Simple configuration object.
 */
class Opus_Model_Xml_Conf {

    /**
     * Holds the current model either directly set or deserialized from XML.
     *
     * @var Opus_Model_Abstract
     */
    public $_model = null;

    /**
     * Holds the current DOM representation.
     *
     * @var DOMDocument
     */
    public $_dom = null;

    /**
     * List of fields to skip on serialization.
     *
     * @var array
     */
    public $_excludeFields = array();

    /**
     * True, if empty fields get excluded from serialization.
     *
     * @var bool
     */
    public $_excludeEmpty = false;

    /**
     * Base URI for xlink:ref elements
     *
     * @var string
     */
    public $_baseUri = '';

    /**
     * Holds Resolver instance to get contents of xlink referenced resources.
     *
     * @var Opus_Uri_Resolver
     */
    public $_xlinkResolver = null;

    /**
     * Map of model class names to resource names for URI generation.
     *
     * @var array
     */
    public $_resourceNameMap = array();

}
