#!/bin/bash
#
# LICENCE
# This code is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This code is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# @author      Sascha Szott <szott@zib.de>
# @copyright   Copyright (c) 2012, OPUS 4 development team
# @license     http://www.gnu.org/licenses/gpl.html General Public License
# @version     $Id: update-migration.sh 10110 2012-01-26 18:30:54Z sszott $


# Migration of Collection-based Series (were eliminated in OPUS 4.2.0)

set -o errexit

source update-common.sh

setVars

DEBUG "BASEDIR = $BASEDIR"
DEBUG "BASE_SOURCE = $BASE_SOURCE"
DEBUG "MD5_OLD = $MD5_OLD"
DEBUG "VERSION_NEW = $VERSION_NEW"
DEBUG "VERSION_OLD = $VERSION_OLD"
DEBUG "_UPDATELOG = $_UPDATELOG"

# Ensure this is only done for updates from versions < 4.2.0
if [[ "$VERSION_OLD" < "4.2" && "$VERSION_NEW" > "4.2" ]]; then
   echo -e "Would you like to migrate collection-based series (see release notes for more details) [y/N]? \c ";
   read ANSWER
    if [[ $ANSWER == 'y' ]]; then
        "$BASEDIR/opus4/scripts/update_migration/MigrateSeriesCollections.php" "$BASEDIR/UPDATE-series.log"
    fi

    "$BASEDIR/opus4/scripts/update_migration/MigrateSubjectsToCollections.php" "$BASEDIR/UPDATE-subjects.log"
fi
