/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.mab.extension.ErrorStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

import de.kobv.mable.mab.extension.ErrorType;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class LieferungsfehlerReport extends AbstractReport {

    private String noErrorsMessage = "Es gab keine Lieferungsfehler.";

    private ErrorStatistics errorStatistics;

    @Override
    public void generate() {
        Logger report = getReport();

        Map<ErrorType, Integer> result = getResult();

        StringWriter strOut = new StringWriter();

        PrintWriter out = new PrintWriter(strOut);

        out.println();
        out.println(getHeader());
        out.println();

        if (result.isEmpty()) {
            out.println(getNoErrorsMessage());
        }
        else {
            out.println(" Anzahl -> Fehlermeldung");
            for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
                out.println(" " + entry.getValue() + " -> (#" + entry.getKey().getCode()
                        + ") " + entry.getKey().getMessage());
            }
        }

        report.info(strOut.toString());
    }

    public String getNoErrorsMessage() {
        return noErrorsMessage;
    }

    public void setNoErrorsMessage(final String message) {
        this.noErrorsMessage = message;
    }

    public Map<ErrorType, Integer> getResult() {
        return getErrorStatistics().getPackageErrors();
    }

    public ErrorStatistics getErrorStatistics() {
        return errorStatistics;
    }

    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    

}
