/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

import de.kobv.mable.mab2.modules.DatasetStatistics;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO handle indentation
 * TODO use resource bundle
 */
public class DatasetTypesReport extends AbstractReport {

    private final static Logger LOG = Logger.getLogger(DatasetTypesReport.class);

    private DatasetStatistics datasetStatistics;

    /**
     * u -> 303, y -> 1 h -> 1204
     */
    @Override
    public void generate() {
        LOG.debug("Generating report");
        Logger report = getReport();

        Map<Character, Integer> typen = getDatasetStatistics().getTypeCount();

        StringWriter strOut = new StringWriter();

        PrintWriter out = new PrintWriter(strOut);
        out.println();
        out.println(getHeader());
        out.println(getHorizontalRule());
        out.println(" Satzstatztyp -> Anzahl");
        out.println(getHorizontalRule());

        for (Map.Entry<Character, Integer> entry : typen.entrySet()) {
            out.println(" " + entry.getKey() + " -> " + entry.getValue());
        }
        out.println(getHorizontalRule());

        report.info(strOut.toString());
    }

    public DatasetStatistics getDatasetStatistics() {
        return datasetStatistics;
    }

    public void setDatasetStatistics(DatasetStatistics datasetStatistics) {
        this.datasetStatistics = datasetStatistics;
    }

}
