/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports;

import de.kobv.mable.util.XmlResourceBundleControl;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public abstract class AbstractReport implements ReportModule {

    private Logger report;

    private String header;

    private String message;

    private String messageKey;

    private String horizontalRule = "+" + StringUtils.leftPad("+", 77, "-");

    /**
     * TODO not necessarily resource for all reports (move!)
     */
    private ResourceBundle messages =
            ResourceBundle.getBundle("de/kobv/mable/report/text/mable-report-messages",
            new XmlResourceBundleControl());

    public Logger getReport() {
        return report;
    }

    public void setReport(final Logger logger) {
        this.report = logger;
    }

    @Override
    public void generate() {
        throw new UnsupportedOperationException("report not implemented");
    }

    public String getHorizontalRule() {
        return horizontalRule;
    }

    public void setHorizontalRule(final String rule) {
        this.horizontalRule = rule;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(final String headerstr) {
        this.header = headerstr;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(final String msg) {
        this.message = msg;
    }

    public String getMessageKey() {
        return messageKey;
    }

    public void setMessageKey(final String key) {
        this.messageKey = key;
    }

    public ResourceBundle getMessages() {
        return messages;
    }

    public void setMessages(final ResourceBundle bundle) {
        this.messages = bundle;
    }

}
