/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.util;

import java.util.Comparator;
import java.util.Map;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ValueComparator implements Comparator<String> {

    private Map<String, Integer> valueMap;

    public ValueComparator(Map<String, Integer> valueMap){
        this.valueMap = valueMap;
    }

    @Override
    public int compare(String key1, String key2) {
        Integer value1 = valueMap.get(key1);
        Integer value2 = valueMap.get(key2);

        return value2.compareTo(value1);
    }

}
