/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.text;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.handler.ReportWriterFactory;
import de.kobv.mable.mab.extension.IErrorStatistics;
import de.kobv.mable.reports.AbstractReport;
import de.kobv.mable.reports.Report;
import de.kobv.mable.reports.log4j.Log4jReportWriterFactory;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/6/12
 * Time: 2:01 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ErrorCodeIndexReport implements Report {

    private Logger report;

    private ReportWriterFactory reportWriterFactory;

    private IErrorStatistics errorStatistics;

    @Override
    public void generate() {
        StringWriter stringWriter = new StringWriter();

        PrintWriter out = new PrintWriter(stringWriter);

        errorStatistics.writeIndex(out);

        Logger log = getReportLogger("codes");

        log.info(stringWriter.toString());
    }

    @Override
    public void setReport(Logger logger) {
        report = logger;
    }

    public void setReportWriterFactory(ReportWriterFactory reportWriterFactory) {
        this.reportWriterFactory = reportWriterFactory;
    }

    public void setErrorStatistics(IErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    protected Logger getReportLogger(String loggerName) {
        Logger logger = null;

        Log4jReportWriterFactory reportFactory = new Log4jReportWriterFactory();
        String name = ( String ) MableProperties.getProperty("filename");
        String logTimestamp = ( String )MableProperties.getProperty("timestampString");
        try {
            logger = reportFactory.getReportWriter(name, loggerName, logTimestamp, "_Mable-" + loggerName + ".txt");
        }
        catch (IOException ioe) {
            // TODO do something
        }

        return logger;
    }

}
