/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.csv;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorLogger;
import de.kobv.mable.reports.log4j.Log4jReportWriterFactory;
import java.io.IOException;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class CsvErrorLogger implements ErrorLogger {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(CsvErrorLogger.class);

    /**
     * Logger for error log.
     */
    private Logger errorLogger;

    /**
     *
     * @param error DatasetError
     */
    @Override
    public void logError(final DatasetError error) {
        logError(error, null);
    }

    @Override
    public void logError(final DatasetError error, final String message) {
        if (error == null) {
            throw new NullPointerException("logError : error is null");
        }
        writeError(error.getSatzId(), error.getErrorType().getCode(), message);
    }

    private void writeError(final String datasetId, final int errorCode, String message) {
        if (datasetId == null) {
            LOG.error("Attempting to log error (" + errorCode
                    + ") without 001 information. ");
        }
        if (message == null) {
            getErrorLogger().info(datasetId + ", #" + errorCode);
        }
        else {
            getErrorLogger().info(datasetId + ", #" + errorCode + ", " + message);
        }
    }

    /**
     *
     * @return
     *
     * TODO externalize! Less dependencies!
     */
    public Logger getErrorLogger() {
        if (errorLogger == null) {
            Log4jReportWriterFactory reportFactory = new Log4jReportWriterFactory();
            String name = ( String )MableProperties.getProperty("filename");
            String logTimestamp = ( String )MableProperties.getProperty("timestampString");
            try {
                errorLogger = reportFactory.getReportWriter(name, "errors", logTimestamp, "_Mable-errors.txt");
            }
            catch (IOException ioe) {
                // TODO do something
            }
            errorLogger.info("Mable-Gefundene Fehler zu MAB-Datei " + name);
            errorLogger.info("Datensatz-ID, Fehlercode, Weitere Informationen");
        }
        return errorLogger;
    }

}
