/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DefaultReferencesStore;
import de.kobv.mable.mab.extension.ReferencesStore;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/24/12
 * Time: 3:14 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ReferencesHolderTest {

    private ReferencesStore referencesStore;

    private ReferencesHolder module;

    @Before
    public void before() {
        referencesStore = new DefaultReferencesStore();
        module = new ReferencesHolder();
        module.setReferencesStore(referencesStore);
    }

    @Test
    public void testProcessSatz() {
        MabSatz satz = new MabSatz("01024nM2.01200024      h");
        satz.addFeld(new MabFeld(1, ' ', "ID0001"));

        module.process(satz);

        assertTrue(referencesStore.isDatasetExists("ID0001"));
        assertTrue(referencesStore.isDatasetExists("ID0001", "h"));
    }

    @Test
    public void testProcessTwoDatasetWithSameId() {
        MabSatz satz1 = new MabSatz("01024nM2.01200024      h");
        satz1.addFeld(new MabFeld(1, ' ', "ID0001"));

        MabSatz satz2 = new MabSatz("01024nM2.01200024      h");
        satz2.addFeld(new MabFeld(1, ' ', "ID0001"));

        module.process(satz1);
        module.process(satz2);

        assertTrue(referencesStore.isDatasetExists("ID0001"));
        assertTrue(referencesStore.isDatasetExists("ID0001", "h"));
    }

    @Test
    @Ignore(value="add check for reporting of error")
    public void testProcessSatzWithoutId() {
        MabSatz satz = new MabSatz("01024nM2.01200024      h");

        module.process(satz);
    }

    @Test
    @Ignore
    public void testReportMultipleIds() {

    }

    @Test
    @Ignore
    public void testReportDuplicatedId() {

    }

}
