/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.extension.DatasetError;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/29/12
 * Time: 12:15 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class PndWithoutNameErrorTypeTest {

    @Test
    public void testConstruct() {
        PndWithoutNameErrorType errorType = new PndWithoutNameErrorType();
    }

    @Test
    public void testConstructDataset() {
        DatasetError error = new DatasetError(new PndWithoutNameErrorType(), "ID0001");

        assertNotNull(error.getErrorType());
        assertEquals(new PndWithoutNameErrorType(), error.getErrorType());
    }

    @Test
    public void testGetMessageNotNull() {
        PndWithoutNameErrorType errorType = new PndWithoutNameErrorType();

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEquals() {
        PndWithoutNameErrorType errorType = new PndWithoutNameErrorType();

        assertEquals("PND-Nummer ohne zugehörigen Personennamen. (z.B. MAB-Feld 102, jedoch kein MAB-Feld 100).", errorType.getMessage());
    }

}
