/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import org.junit.Ignore;
import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/27/12
 * Time: 2:04 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class IsbnErrorTypeTest {

    @Test
    public void testCreateIsbnErrorType() {
        IsbnErrorType errorType = new IsbnErrorType(IsbnErrorType.INVALID_ISBN_IN_540A);

        assertEquals(IsbnErrorType.INVALID_ISBN_IN_540A, errorType.getMessageKey());
    }

    @Test
    public void testGetMessageNotNull() {
        IsbnErrorType errorType = new IsbnErrorType(IsbnErrorType.INVALID_ISBN_IN_540A);

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEquals() {
        IsbnErrorType errorType = new IsbnErrorType(IsbnErrorType.INVALID_ISBN_IN_540A);

        assertEquals("ISBN in MAB 540a ist formal falsch.", errorType.getMessage());
    }

}
