/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Unit tests for class IsbnError.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class IsbnErrorTest {

    private static final String VALID_KENNUNG = "01024nM2.01200024      h";

    private MabSatz satz;

    @Before
    public void before() {
        satz = new MabSatz(VALID_KENNUNG);
        satz.addFeld(new MabFeld(1, ' ', "ID0001"));
    }

    @Test
    public void testCreateIsbnError() {
        IsbnError error = new IsbnError(satz, new IsbnErrorType(IsbnErrorType.ISBN_IN_540Z), "feldinhalt");
        assertEquals("ID0001", error.getSatzId());
        assertEquals("feldinhalt", error.getContent());
        assertEquals(IsbnErrorType.ISBN_IN_540Z, (( IsbnErrorType )error.getErrorType()).getMessageKey());
    }

    @Test
    public void testGetErrorType() {
        IsbnError error = new IsbnError(satz, new IsbnErrorType(IsbnErrorType.INVALID_ISBN_IN_540A), "feldinhalt");
        assertNotNull(error.getErrorType());
    }

    @Test
    public void testDifferentErrorTypeForDifferentIsbnErrors() {
        IsbnError error1 = new IsbnError(satz, new IsbnErrorType(IsbnErrorType.INVALID_ISBN_IN_540A), "feldinhalt");
        IsbnError error2 = new IsbnError(satz, new IsbnErrorType(IsbnErrorType.ISBN_IN_540Z), "feldinhalt");
        assertFalse(error1.getErrorType() == error2.getErrorType());
    }

}
