/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.junit.Ignore;
import org.junit.Test;

/**
 * Unit tests for class DatasetWithoutIdLogger.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class DatasetWithoutIdLoggerTest {

    @Test
    @Ignore
    public void testSatzMit001Feld() {
        MabSatz satz = new MabSatz("01024nM2.01200024      h");

        satz.addFeld(new MabFeld(1, ' ', "ID0001"));

        Mockery mockery = new Mockery();

        final Logger mockLogger = mockery.mock(Logger.class);

        DatasetWithoutIdLogger module = new DatasetWithoutIdLogger();

        module.setLogger(mockLogger);

        mockery.checking(new Expectations() {
            {
                never(mockLogger).info(with(any(String.class)));
            }
        });

        module.process(satz);

        mockery.assertIsSatisfied();
    }

    @Test
    @Ignore
    public void testSatzOhne001Feld() {

    }

}
