/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.MabSatzkennung;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * Unit Tests for class DatasetStatistics.
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class DatasetStatisticsTest {

    @Test
    public void testConstruction() {
        DatasetStatistics stats = new DatasetStatistics();

        assertEquals(0, stats.getDatasetCount());
        assertEquals(0, stats.getTypeCount().size());
        assertEquals(0, stats.getStatusCount().size());
    }

    @Test
    public void testAddDataset() {
        DatasetStatistics stats = new DatasetStatistics();

        stats.addDataset('h', 'n');

        assertEquals(1, stats.getDatasetCount());
        assertEquals(1, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getStatusCount().get('n').intValue());

        stats.addDataset('u', 'n');

        assertEquals(2, stats.getDatasetCount());
        assertEquals(1, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getTypeCount().get('u').intValue());
        assertEquals(2, stats.getStatusCount().get('n').intValue());

        stats.addDataset('h', 'p');

        assertEquals(3, stats.getDatasetCount());
        assertEquals(2, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getTypeCount().get('u').intValue());
        assertEquals(2, stats.getStatusCount().get('n').intValue());
        assertEquals(1, stats.getStatusCount().get('p').intValue());
    }

    @Test
    public void testBeginDataset() {
        DatasetStatistics stats = new DatasetStatistics();

        stats.process(new MabSatz(new MabSatzkennung(0, "h", "n")));

        assertEquals(1, stats.getDatasetCount());
        assertEquals(1, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getStatusCount().get('n').intValue());

        stats.process(new MabSatz(new MabSatzkennung(0, "u", "n")));

        assertEquals(2, stats.getDatasetCount());
        assertEquals(1, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getTypeCount().get('u').intValue());
        assertEquals(2, stats.getStatusCount().get('n').intValue());

        stats.process(new MabSatz(new MabSatzkennung(0, "h", "p")));

        assertEquals(3, stats.getDatasetCount());
        assertEquals(2, stats.getTypeCount().get('h').intValue());
        assertEquals(1, stats.getTypeCount().get('u').intValue());
        assertEquals(2, stats.getStatusCount().get('n').intValue());
        assertEquals(1, stats.getStatusCount().get('p').intValue());
    }

}
