/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/3/12
 * Time: 11:33 AM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class BadExtraFieldErrorTypeTest {

    @Test
    public void testGetMessageNotNull() {
        BadExtraFieldErrorType errorType = new BadExtraFieldErrorType(null, "090");

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEquals() {
        BadExtraFieldErrorType errorType = new BadExtraFieldErrorType(null, "090");

        assertEquals("Satz mit Feld 090 (Bandangaben in Sortierform).", errorType.getMessage());
    }

    @Test
    public void testGetMessageNotNullWithSatztyp() {
        BadExtraFieldErrorType errorType = new BadExtraFieldErrorType("u", "090");

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEqualsWithSatztyp() {
        BadExtraFieldErrorType errorType = new BadExtraFieldErrorType("u", "090");

        assertEquals("u-Satz mit Feld 090 (Bandangaben in Sortierform).", errorType.getMessage());
    }

}
