/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabException;
import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import static org.junit.Assert.*;

import java.util.List;

/**
 * Unit Tests for class AtLeastOneField.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class AtLeastOneFieldTest {

    /**
     * Valid MAB dataset header for testing.
     */
    public static final String VALID_KENNUNG = "01024nM2.01200024      h";

    private MabSatz satz;

    private AtLeastOneField module;

    private MockErrorStatistics errorStatistics;

    @Before
    public void before() {
        satz = new MabSatz(VALID_KENNUNG);
        module = new AtLeastOneField();
        module.setSatzTyp('h');
        module.setKategorie("051");
        module.setZweiteKategorie("052");
        errorStatistics = new MockErrorStatistics();
        module.setErrorStatistics(errorStatistics);
    }

    @Test
    public void testNoFieldFound() {
        module.process(satz);

        List<DatasetError> errors = errorStatistics.getErrors();

        assertEquals(1, errors.size());
        assertTrue(errors.get(0) instanceof DatasetError);
    }

    @Test
    public void testFirstFieldFound() throws MabException {
        satz.addFeld(new MabFeld("051", ' '));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testSecondFieldFound() throws MabException {
        satz.addFeld(new MabFeld("052", ' '));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testBothFieldsFound() throws MabException {
        satz.addFeld(new MabFeld("051", ' '));
        satz.addFeld(new MabFeld("052", ' '));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testSetZweiteFeldnummer() {
        module.setZweiteFeldnummer(90);
        assertEquals("090", module.getZweiteKategorie());
    }

}
