/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2;

import de.kobv.mable.mab.MabSatzkennung;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 */
public class DefaultMabDataHandlerTest {

    /**
     * Valid MAB dataset header for testing.
     */
    public static final String VALID_KENNUNG = "01024nM2.01200024      h";

    @Test
    public void testStartSatz() {
        DefaultMabDataHandler handler = new DefaultMabDataHandler();

        MabSatzkennung satzkennung = new MabSatzkennung(VALID_KENNUNG);

        handler.startSatz(satzkennung);

        assertEquals(VALID_KENNUNG, handler.getCurrentDataset().getKennung());
    }

}
