/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import org.apache.log4j.Logger;

/**
 *
 * TODO how to handle just category and category + Indikator
 */
public class RequiredCategory extends AbstractMabCheck {

    private final static Logger LOG = Logger.getLogger(RequiredCategory.class);

    /**
     * TODO implement
     * @param satz
     */
    @Override
    public void process(MabSatz satz) {
        // LOG.debug("Checking Satz '" + satz.getId() + "' for category '" + getFeldnummer() + "'.");

        char satztyp = getSatzTyp();

        // Nur prüfen, wenn kein Satztyp spezifiziert wurde, oder wenn der Satztyp übereinstimmt
        if (satztyp == 0 || satztyp == satz.getSatzkennung().getTyp() ) {
            if (!satz.isFeldPresent(getKategorie(), getIndikator())) {
                LOG.debug("Checking Satz '" + satz.getId() + "' for category '" + getKategorie() + "'.");
                DatasetError error = getError(satz);
                getErrorStatistics().addError(getError(satz));
            }
        }
    }

    private DatasetError getError(MabSatz satz) {
        String satzTyp = null;

        if (getSatzTyp() != 0) {
            satzTyp = Character.toString(getSatzTyp());
        }

        DatasetError error = new DatasetError(new RequiredCategoryErrorType(getKategorie(), satzTyp,
                getErrorMessageKey(), getErrorCode()), satz.getId());
        return error;
    }

    public String toString() {
        return super.toString() + "[" + getKategorie() + "]";
    }

}
