/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.*;
import de.kobv.mable.mab.extension.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Stores content of all MAB001 fields for reference checking.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ReferencesHolder extends AbstractMableModule2 {

    /**
     * Bean for storing dataset references.
     */
    @Autowired
    private ReferencesStore referencesStore;

    /**
     * Stores current dataset type for processing.
     */
    @Override
    public void process(final MabSatz satz) {
        List<IMabFeld> felder = satz.getFelder(MabFeldDefinition.MAB001);

        if (felder != null && felder.size() > 0) {
            if (felder.size() == 1) {
                try {
                    IMabFeld feld = felder.get(0);
                    getReferencesStore().addDataset(feld.getInhalt(), satz.getSatzkennung().getTyp());
                }
                catch (IdentifierAlreadyExistsException iaee) {
                    // TODO report doppelte Verwendung von ID
                }
            }
            else {
                // TODO report multiple MAB001 Felder
            }
        }
        else {
            // TODO report missing 001 error
        }
    }

    /**
     * Getter for bean storing dataset references.
     * @return ReferencesStore
     */
    public ReferencesStore getReferencesStore() {
        return referencesStore;
    }

    /**
     * Setter for bean storing dataset references.
     * @param store ReferencesStore
     */
    public void setReferencesStore(final ReferencesStore store) {
        this.referencesStore = store;
    }

}
