/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;

import java.util.List;

/**
 * Module for checking for PNDs (102, ) without name field (100, ).
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO setErrorCode(2212);
 * TODO setErrorMessageKey("PND_NUMMER_OHNE_NAME");
 * TODO use base class for PND and GKD
 */
public class PndWithoutName extends AbstractMabCheck {

    /**
     * First PND field.
     */
    protected int feldnummer1 = 102;

    /**
     * First name fields.
     */
    protected int feldnummer2 = 100;

    /**
     * Increment between two pairs of fields for check.
     */
    protected int increment = 4;

    /**
     * Number of pairs of fields that should be checked.
     */
    protected int anzahl = 25;

    /**
     *
     * @param satz
     */
    public void process(final MabSatz satz) {
        for (int i = 0; i < anzahl; i++) {
            int feld1 = feldnummer1 + i * increment;
            int feld2 = feldnummer2 + i * increment;

            List<IMabFeld> felder1 = satz.getFelder(MabFeldDefinition.getFeld(feld1));

            List<IMabFeld> felder2 = satz.getFelder(MabFeldDefinition.getFeld(feld2));

            boolean feld1Found = felder1 != null && felder1.size() > 0;
            boolean feld2Found = felder2 != null && felder2.size() > 0;

            if (feld1Found && !feld2Found) {
                getErrorStatistics().addError(getError(satz));
            }
        }
    }

    protected DatasetError getError(MabSatz satz) {
        return new DatasetError(new PndWithoutNameErrorType(getErrorMessageKey(), getErrorCode()), satz.getId());
    }

}
