/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.MableModule2;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * Counts occurrence of MAB2 categories and leaders.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO support statistics for Aleph Felder
 */
public class FieldStatistics extends AbstractMableModule2 {

    /**
     * Holds count for each MAB2 category and leader.
     */
    private Map<String, Integer> fieldCount = new HashMap<String, Integer>();

    /**
     * Adds a MAB2 category and leader or increases the counter if already
     * present.
     *
     * @param fieldType MAB2 field identifier, e.g. "025z"
     */
    public void addField(final String fieldType) {
        int count;

        if (fieldCount.containsKey(fieldType)) {
            count = fieldCount.get(fieldType);
        }
        else {
            count = 0;
        }

        fieldCount.put(fieldType, count + 1);
    }

    /**
     * ŦODO needed?
     */
    public void addField(final int number, final char leader) {
        String fieldType = String.format("%1$03d", number) + leader; // TODO review
        addField(fieldType);
    }

    /**
     * Returns statistics.
     *
     * @return
     */
    public Map<String, Integer> getFieldCount() {
        return new TreeMap<String, Integer>(fieldCount);
    }

    @Override
    public void process(final MabSatz satz) {
        for (IMabFeld feld : satz.getFelder()) {
            addField(feld.getFeldnummer(), ( char )feld.getIndikator());
        }
    }

}
