/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/24/12
 * Time: 1:51 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class FieldDependencyErrorType extends ErrorType {

    private int errorHash;

    private String kategorie1;

    private String kategorie2;

    public FieldDependencyErrorType(String kategorie1, String kategorie2) {
        this.kategorie1 = kategorie1;
        this.kategorie2 = kategorie2;
    }

    public String getKategorie1() {
        return kategorie1;
    }

    public String getKategorie2() {
        return kategorie2;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            msg = "Satz mit " + kategorie1 + ", aber ohne " + kategorie2 + ".";
        }
        return msg;
    }

    public String toString() {
        return super.toString() + "[" + kategorie1 + ", " + kategorie2 + "]";
    }

    @Override
    public int getHash() {
        if (errorHash == 0) {
            errorHash = new HashCodeBuilder()
                    .append(getClass())
                    .append(kategorie1)
                    .append(kategorie2)
                    .toHashCode();
        }
        return errorHash;
    }

}
