/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.MableModule2;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * Captures the total dataset count, as well as the count for type and status.
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO use array for fixed number of possible types, states
 * TODO make thread-safe
 * TODO refactor? combine with references store?
 * TODO rename? DatasetCounter?
 */
public class DatasetStatistics extends AbstractMableModule2 {

    /**
     * Logger for this class.
     */
    private final static Logger LOG = Logger.getLogger(DatasetStatistics.class);

    /**
     * Counter for number of datasets.
     */
    private int datasetCount = 0;

    /**
     * Stores the number of datasets of each type.
     * TODO verify possible values
     */
    private Map<Character, Integer> typeCount =
            new HashMap<Character, Integer>();

    /**
     * Stores the number of datasets in each status.
     * TODO verify possible values
     */
    private Map<Character, Integer> statusCount =
            new HashMap<Character, Integer>();

    /**
     * Adds a new dataset to the statistic.
     * @param type MAB2 dataset type
     * @param status MAB2 dataset status
     */
    public void addDataset(final Character type, final Character status) {
        this.datasetCount++;

        Integer counter = typeCount.get(type);
        if (counter == null) {
            counter = new Integer(1);
            typeCount.put(type, counter);
        }
        else {
            counter = new Integer(counter.intValue() + 1);
            typeCount.put(type, counter);
        }

        counter = statusCount.get(status);
        if (counter == null) {
            counter = new Integer(1);
            statusCount.put(status, counter);
        }
        else {
            counter = new Integer(counter.intValue() + 1);
            statusCount.put(status, counter);
        }
    }

    /**
     * Returns the result of the type count.
     * @return Map of type characters and count
     */
    public Map<Character, Integer>getTypeCount() {
        return typeCount;
    }

    /**
     * Returns the result of the status count.
     * @return Map of the status characters and count
     */
    public Map<Character, Integer>getStatusCount() {
        return statusCount;
    }

    /**
     * Returns the number of datasets counted.
     * @return Integer count of datasets added
     */
    public int getDatasetCount() {
        return this.datasetCount;
    }

    @Override
    public void process(MabSatz satz) {
        LOG.debug("Processing Satz");
        String type = Character.toString(satz.getSatzkennung().getTyp());
        String status = Character.toString(satz.getSatzkennung().getStatus());
        this.addDataset(type.charAt(0), status.charAt(0));
    }
}
