/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/24/12
 * Time: 11:37 AM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class BadExtraFieldErrorType extends ErrorType {

    private int errorHash;

    private String satzTyp;

    private String kategorie;

    public BadExtraFieldErrorType(String satzTyp, String kategorie) {
        this.satzTyp = satzTyp;
        this.kategorie = kategorie;
    }

    public BadExtraFieldErrorType(String satzTyp, String kategorie, String message, int errorCode) {
        super(message, errorCode);
        this.satzTyp = satzTyp;
        this.kategorie = kategorie;
    }

    public String getSatzTyp() {
        return satzTyp;
    }

    public String getKategorie() {
        return kategorie;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            String feldname = getFeldname(kategorie);
            if (feldname != null) {
                feldname = " (" + feldname + ")";
            }
            else {
                feldname = "";
            }

            if (satzTyp == null) {
                msg = "Satz mit Feld " + kategorie + feldname + ".";
            }
            else {
                msg = satzTyp + "-Satz mit Feld " + kategorie + feldname + ".";
            }
        }
        return msg;
    }

    @Override
    public int getHash() {
        if (errorHash == 0) {
            errorHash = new HashCodeBuilder()
                    .append(getClass())
                    .append(satzTyp)
                    .append(kategorie)
                    .toHashCode();
        }
        return errorHash;
    }

    public String toString() {
        return super.toString() + "[" + kategorie + "]";
    }

}
