/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.IErrorStatistics;
import de.kobv.mable.mab.extension.MableModule2;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/15/12
 * Time: 3:26 PM
 * To change this template use File | Settings | File Templates.
 *
 * TODO rename to AbstractMabFieldCheck
 */
public abstract class AbstractMabCheck implements MableModule2 {

    /**
     * MAB category (Feldnummer).
     */
    private String feldnummer;

    /**
     * MAB Feldindikator (leader).
     */
    private char indikator;

    /**
     * MAB Satztyp.
     */
    private char satzTyp;

    private IErrorStatistics errorStatistics;

    private ErrorType errorType;

    private String errorMessageKey;

    private int errorCode;

    public char getSatzTyp() {
        return satzTyp;
    }

    public String getSatzTypAsString() {
        if (satzTyp == 0) {
            return null;
        }
        else {
            return Character.toString(satzTyp);
        }
    }

    public void setSatzTyp(final char typ) {
        this.satzTyp = typ;
    }

    public String getKategorie() {
        return feldnummer;
    }

    public void setKategorie(final String kategorie) {
        this.feldnummer = kategorie;
    }

    public char getIndikator() {
        return indikator;
    }

    public void setIndikator(final char indikator) {
        this.indikator = indikator;
    }

    @Override
    public void init() throws MableConfigurationException {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void finish() {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void process(MabSatz satz) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void setFeldnummer(final int nummer) {
        setKategorie(MabFeldDefinition.getFeldnummerString(nummer));
    }

    public IErrorStatistics getErrorStatistics() {
        return errorStatistics;
    }

    /**
     * @param errorStatistics
     */
    @Autowired
    public void setErrorStatistics(IErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public String getMessage(final String key) {
        // TODO implement
        return null;
    }

    public ErrorType getErrorType() {
        return errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getErrorMessageKey() {
        return errorMessageKey;
    }

    public void setErrorMessageKey(String messageKey) {
        this.errorMessageKey = messageKey;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
}
