/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.validation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.junit.Ignore;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class MabCharsetCheckerTest {

    @Test
    public void testDuplicates() {
        int[] chars = MabCharsetChecker.VALID_CHARS;

        Set<Integer> charSet = new HashSet<Integer>();

        Set<Integer> duplicates = new HashSet<Integer>();

        for (int character : chars) {
            Integer value = Integer.valueOf(character);
            if (charSet.contains(value)) {
                duplicates.add(value);
                System.out.println("Duplicate character: " +
                    String.format("0x%1$04X", value));
            }
            else {
                charSet.add(value);
            }
        }

        assertTrue(duplicates.isEmpty());
    }

    @Test
    public void checkAllValid() {
        int[] chars = MabCharsetChecker.VALID_CHARS;

        for (int character : chars) {
            assertTrue("Invalid character: " +
                String.format("0x%1$04X", character),
                MabCharsetChecker.checkUTF8bytes(character));
        }
    }

    @Test
    public void checkInvalidCharacter() {
        assertFalse(MabCharsetChecker.checkUTF8bytes(0x0015));
    }

    @Test
    @Ignore
    public void testMatchBetweenCheckerAndMabCharset() {
        // TODO is it possible?
    }

    /**
     * Test private constructor (for 100% coverage).
     * @throws NoSuchMethodException
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    @Test
    public void testPrivateConstructor() throws NoSuchMethodException,
        InstantiationException, IllegalAccessException,
        InvocationTargetException {
        Constructor constructor =
                MabCharsetChecker.class.getDeclaredConstructor();
        constructor.setAccessible(true);
        constructor.newInstance();
    }

}
