/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import org.junit.Ignore;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Unit Tests for class ErrorType.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO ErrorType und ErrorCodeManager verwenden statische Variablen; daher können die Unit Tests sich beeinflußen
 */
public class ErrorTypeTest {

    @Test
    @Ignore
    public void testNewInstance() {
        ErrorType errorType = null;

        assertEquals(1, errorType.getHash());
        assertTrue(errorType.getCode() >= 5000);
        assertNull(errorType.getMessage());
    }

    @Test
    @Ignore
    public void testNewInstanceWithMessage() {
        ErrorType errorType = null; // ErrorType.newInstance(2, "message");

        assertEquals(2, errorType.getHash());
        assertTrue(errorType.getCode() >= 5000);
        assertEquals("message", errorType.getMessage());
    }

    @Test
    @Ignore
    public void testNewInstanceWithMessageAndCode() throws Exception {
        ErrorType errorType = null; // ErrorType.newInstance(3, "message2", 2000);

        assertEquals(3, errorType.getHash());
        assertEquals(2000, errorType.getCode());
        assertEquals("message2", errorType.getMessage());
    }

}
