/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import java.util.Set;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class DefaultReferencesStoreTest {

    @Test
    public void testAddDataset() throws IdentifierAlreadyExistsException {
        DefaultReferencesStore store = new DefaultReferencesStore();

        store.addDataset("10000", 'h');
        store.addDataset("20000", 'u');

        assertTrue(store.isDatasetExists("10000", "h"));
        assertTrue(store.isDatasetExists("10000"));
        assertTrue(store.isDatasetExists("20000"));
    }

    @Test
    public void testGetMissingDatasets() {
        DefaultReferencesStore store = new DefaultReferencesStore();

        Set<String> missing = store.getMissingDatasets();

        assertTrue(missing.isEmpty());

        store.isDatasetExists("10000");
        store.isDatasetExists("20000");

        missing = store.getMissingDatasets();

        assertEquals(2, missing.size());
        assertTrue(missing.contains("10000"));
        assertTrue(missing.contains("20000"));
    }

    @Test
    public void testGetMissingDatasetsWithType() {
        DefaultReferencesStore store = new DefaultReferencesStore();

        Set<String> missing = store.getMissingDatasets();

        assertTrue(missing.isEmpty());

        store.isDatasetExists("10000", "h");
        store.isDatasetExists("20000", "u");

        missing = store.getMissingDatasets();

        assertEquals(2, missing.size());
        assertTrue(missing.contains("10000"));
        assertTrue(missing.contains("20000"));
    }

    @Test
    public void testRemovingDatasetsFromMissing()
            throws IdentifierAlreadyExistsException {
        DefaultReferencesStore store = new DefaultReferencesStore();

        store.isDatasetExists("10000", "h");
        store.isDatasetExists("20000", "h");

        Set<String> missing = store.getMissingDatasets();

        assertEquals(2, missing.size());
        assertTrue(missing.contains("10000"));

        store.addDataset("10000", 'h');

        missing = store.getMissingDatasets();

        assertEquals(1, missing.size());
        assertFalse(missing.contains("10000"));
        assertTrue(missing.contains("20000"));
    }

    @Test
    public void testRemovingDatasetsFromMissingWithoutType()
            throws IdentifierAlreadyExistsException {
        DefaultReferencesStore store = new DefaultReferencesStore();

        store.isDatasetExists("10000");
        store.isDatasetExists("20000");

        Set<String> missing = store.getMissingDatasets();

        assertEquals(2, missing.size());
        assertTrue(missing.contains("10000"));

        store.addDataset("10000", 'h');

        missing = store.getMissingDatasets();

        assertEquals(1, missing.size());
        assertFalse(missing.contains("10000"));
        assertTrue(missing.contains("20000"));
    }

}
