/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.aleph;

import de.kobv.mable.mab.parser.DefaultContentHandler;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.junit.*;
import static org.junit.Assert.*;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class AlephSeqParserTest {

    public AlephSeqParserTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of parse method, of class AlephSeqParser.
     */
    @Test
    public void testParse_File() throws Exception {
        System.out.println("parse");
        File file = new File("src/test/resources/aleph/fub_sample.aleph");
        AlephSeqParser parser = new AlephSeqParser();
        parser.setContentHandler(new DefaultContentHandler());
        parser.parse(file);
    }

    /**
     * Test of parse method, of class AlephSeqParser.
     */
    @Test
    @Ignore
    public void testParse_InputStream() {
        System.out.println("parse");
        InputStream instream = null;
        AlephSeqParser instance = new AlephSeqParser();
        instance.parse(instream);
        // TODO review the generated test code and remove the default call to fail.
        fail("The test case is a prototype.");
    }

    /**
     * Test of parse method, of class AlephSeqParser.
     */
    @Test
    @Ignore
    public void testParse_Reader() {
        System.out.println("parse");
        Reader reader = null;
        AlephSeqParser instance = new AlephSeqParser();
        instance.parse(reader);
        // TODO review the generated test code and remove the default call to fail.
        fail("The test case is a prototype.");
    }
}
