/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable;

import java.util.EnumSet;
import org.apache.commons.lang.StringUtils;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import org.junit.Test;

/**
 * Tests ErrorCode enum containing defined Mable error codes.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ErrorCodeTest {

    /**
     * Tests getting error code for enum value.
     */
    @Test
    public void retrieveErrorCode() {
        assertEquals(2150, ErrorCode.FELDENDE_OHNE_FELD.getCode());
    }

    /**
     * Tests if a message can be retrieved for every error code.
     */
    @Test
    public void retrieveErrorMessage() {
        for (ErrorCode error : EnumSet.allOf(ErrorCode.class)) {
            assertFalse("Message for key " + error.name() + " is missing.",
                StringUtils.isBlank(error.getMessage()));
        }
    }

    /**
     * Tests if additional unused messages have been defined.
     * TODO implement
     */
    @Test
    public void checkForAdditionalMessages() {

    }

    /**
     * Tests if error code enum can be looked up using integer error code.
     */
    @Test
    public void reverseLookup() {
        assertEquals(2150, ErrorCode.get(2150).getCode());
    }

}
