/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/5/12
 * Time: 4:56 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class SubsetSatzfehlerStatistics extends ErrorReportParser {

    // TODO private Set<String> saetze;

    private Map<String, Integer> errorsForDataset = new HashMap<String, Integer>();

    private Map<String, Integer> errorsCount = new HashMap<String, Integer>();

    private Map<Integer, Map<String, Integer>> allErrorsCount = new HashMap<Integer, Map<String, Integer>>();

    @Override
    public void processEntry(final String satzId, final String errorCode) {
        /* TODO used with saetze (vielleicht zwei Klassen?) Refactor!
        if (saetze.contains(satzId)) {
            if (errorsCount.containsKey(errorCode)) {
                errorsCount.put(errorCode, errorsCount.get(errorCode) + 1);
            }
            else {
                errorsCount.put(errorCode, 1);
            }
        }
        */
        // TODO check what group the dataset belongs too
        int fehleranzahl = errorsForDataset.get(satzId);

        Map<String, Integer> group = allErrorsCount.get(fehleranzahl);

        if (group == null) {
            group = new HashMap<String, Integer>();
            allErrorsCount.put(fehleranzahl, group);
        }

        // TODO count error
        Integer groupFehlerzahl = group.get(errorCode);

        if (groupFehlerzahl == null) {
            groupFehlerzahl = new Integer(1);
        }
        else {
            groupFehlerzahl = groupFehlerzahl + 1;
        }

        group.put(errorCode, groupFehlerzahl);
    }

    public Map<String, Integer> getErrorsForDatasets(int fehlerzahl) {
        return allErrorsCount.get(fehlerzahl);
    }

    /* TODO use or remove?
    public Map<String, Integer> getErrorsForDatasets() {
        return errorsCount;
    }

    public void setSaetze(Set<String> saetze) {
        this.saetze = saetze;
    }
    */

    public void setErrorsForDataset(Map<String, Integer> errorsForDataset) {
        this.errorsForDataset = errorsForDataset;
    }

}
