/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/6/12
 * Time: 2:27 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ErrorCodeIndexReportParser {

    /**
     * Set of IDs for datasets with errors.
     */
    private Map<String, String> messages = new HashMap<String, String>();

    /**
     * Parses ERRORS report file.
     * @param in Reader for data
     * @throws java.io.IOException if error occurs reading the data
     */
    public void parse(final Reader in) throws IOException {
        BufferedReader buf = new BufferedReader(in);

        Pattern pattern = Pattern.compile("#(\\d{4}), (-?\\d*?), (.*)");

        String line;

        while ((line = buf.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                String errorCode = matcher.group(1);
                String errorHash = matcher.group(2);
                String errorMessage = matcher.group(3);

                processEntry(errorCode, errorHash, errorMessage);
            }
        }

    }

    public void processEntry(final String errorCode, String errorHash, String errorMessage) {
        messages.put(errorCode, errorMessage);
    }

    public String getMessageForCode(String errorCode) {
        return messages.get(errorCode);
    }

}
