/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Mable - MAB leicht evaluiert - ist ein Sammlung von Tools zur syntaktischen
 * und teilweisen semantischen &Uuml;berpr&uuml;fung von MAB-Dateien, sowie zur
 * Statistikerhebung. Es überprüft die syntaktische Einhaltung von MAB
 * (auftreten von Satzkennungen, Satz-, Feld- und Unterfeldzeichen usw.), testet
 * auf semantische Konsitenz (also z.B. ob alle in U-Sätzen referenzierte
 * H-Sätze in der MAB-Datei enthalten sind) und erhebt Statistiken über die
 * genuzten MAB-Felder.
 *
 * <h3>Operationen</h3>
 * <p>
 * Mable teilt sich in verschiedene Operationen auf. In der aktuellen Version
 * wird die Überprüfung und Aufnahme von MAB-Dateien in eine Datenbank
 * unterstützt. Geplant sind Operationen, die Tests auf die in die Datenbank
 * aufgenommenen Daten wiederholen oder erstmals ausführen sowie das Erstellen
 * von MAB-Dateien aus den Daten der Datenbank.
 * </p>
 * <h3>Strukturierung</h3>
 * <p>
 * Jede Operation hat eine Klasse, mit einer
 * <code>public static main(String[] argv)</code>-Methode, die die
 * Kommandozeilenparameter einliest und alle benötigten Objekte initialisiert.
 * </p>
 * <h3>Weiter Informationen</h3>
 * <p>
 * Weitere Informationen zu Mable sind in der Online-Hilfe zu finden (starten
 * von Mable.jar ohne Parameter ruft die Online-Hilfe auf) und in den
 * Javadoc-Kommentaren zu den einzelnen Klassen und Methoden. Insbesondere von
 * Interesse dürften folgende Klassen sein:
 * <ul>
 *   <li>{@link de.kobv.mable.Mable}</li>
 *   <li>{@link de.kobv.mable.MAB2Database}</li>
 *   <li>{@link de.kobv.mable.mab2database.MabParser}</li>
 *   <li>{@link de.kobv.mable.mab.MabFieldChecker}</li>
 *   <li>{@link de.kobv.mable.mab.MabCharsetChecker}</li>
 *   <li>{@link de.kobv.mable.ErrorCodes}</li>
 * </ul>
 * </p>
 * <p>
 * Weitere Informationen zu MAB an sich sind auf den Seiten der Deutschen
 * Nationalbibliothek zu finden, speziell unter:
 * <ul>
 *   <li><a href="http://www.d-nb.de/standardisierung/txt/titelmab.txt"
 *       >http://www.d-nb.de/standardisierung/txt/titelmab.txt</a></li>
 *   <li><a href="http://www.d-nb.de/standardisierung/txt/segm000.txt"
 *       >http://www.d-nb.de/standardisierung/txt/segm000.txt</a></li>
 *   <li><a href="http://www.d-nb.de/standardisierung/txt/erw-mab.txt"
 *       >http://www.d-nb.de/standardisierung/txt/erw-mab.txt</a></li>
 * </ul>
 * </p>
 */
package de.kobv.mable;
