/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.xml;

import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab.parser.MabParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/**
 * Parser for reading MABXML files.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO support normalization of values (see ALBERT)
 * TODO support XML validation (see ALBERT)
 * TODO support external processing of datasets (see ALBERT); listener interface for datasets
 * TODO remove MabParser interface; move to child class for Mable
 */
public class MabXmlParser implements MabParser {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(MabXmlParser.class);

    private InputStream source;

    /**
     * Handler for processing MABXML files.
     */
    private MabXmlHandler handler;

    private ContentHandler contentHandler;

    /**
     * TODO get rid of this method
     */
    @Override
    public int getDatasetsIgnored() {
        return 0;
    }

    @Override
    public int getDatasetsProcessed() {
        if (handler != null) {
            return handler.getDatasetsProcessed();
        }
        else {
            return 0;
        }
    }

    private void init() {
        handler = new MabXmlHandler();
        handler.setContentHandler(contentHandler);
    }

    @Override
    public void parse() throws IOException, ParseException {
        init();

        SAXParserFactory factory = SAXParserFactory.newInstance();

        SAXParser parser = null;

        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            // TODO
        }
        catch (SAXException se) {
            // TODO
        }

        try {
            parser.parse(source, handler);
        }
        catch (SAXException se) {
            // TODO
        }
    }

    @Override
    public void setSource(final Reader source) {
        throw new UnsupportedOperationException("Reader not supported");
    }

    @Override
    public void setSource(final InputStream stream) {
        this.source = stream;
    }

    public ContentHandler getContentHandler() {
        return contentHandler;
    }

    public void setContentHandler(final ContentHandler handler) {
        this.contentHandler = handler;
    }

}
