/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Enth&auml;lt alle allgemeinen Klassen von Mable, die sich mit MAB
 * beschäftigen.
 *
 * <h3>Weiter Informationen</h3>
 * <p>
 *   <ul>
 *     <li>{@link de.kobv.mable.mab.MabFieldChecker}</li>
 *     <li>{@link de.kobv.mable.mab.MabCharsetChecker}</li>
 *   </ul>
 * </p>
 *
 * TODO extend to generate XML as well as MAB2CHARSET encoded output
 * TODO How to handle non MAB2 (Aleph) Felder?
 * TODO extend for manipulating MAB2 Sätze (MABLE-266)
 *
 * Offene Fragen:
 *
 * 1) Sollten der Klassen vor der Manipulation der Daten von außen geschützt werden?
 *
 * Wenn die MabSatz Klasse ein Feld zurück liefert, kann der Inhalt des Feldes verändert werden und damit der Satz, da
 * das interne Object für das Feld zurück gegeben wird. Wenn das Feld zu einem anderen Datensatz hinzugefügt wird, dann
 * ist es mit zwei Datensätzen verknüpft und eine Änderung des Wertes in einem, ändert auch den anderen Satz.
 *
 * Das kann verhindert werden indem die internen Datenobjekte isoliert werden. Das heißt beim Hinzufügen und Entfernen
 * werden die Datenobjekte geklont. Das hat natürlich Auswirkungen auf die Geschwindigkeit.
 *
 * <b>Vielleicht sollten die Basisklassen und Interfaces nicht modifzierbar sein und dann können bei Bedarf Klassen
 * geschrieben werden, die eine Manipulation der Daten erlauben.</b>
 *
 */
package de.kobv.mable.mab;
