/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import java.util.Set;

/**
 * Inferface for class that stores MAB001 references.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public interface ReferencesStore {

    /**
     * Add a datasetId to reference.
     *
     * @param datasetId Content of MAB001 field
     * @throws IdentifierAlreadyExistsException if the identifier already exists
     * in the store
     */
    void addDataset(String datasetId, char datasetType)
            throws IdentifierAlreadyExistsException;

    /**
     * Return true if the datasetId exists.
     *
     * @param datasetId Dataset identifier (MAB001)
     * @return true - if dataset exists, false - if dataset does not exist
     */
    boolean isDatasetExists(String datasetId);

    boolean isDatasetExists(String datasetId, String datasetType);

    /**
     * Returns the set of missing dataset identifiers.
     */
    Set<String> getMissingDatasets();

    /**
     * Adds a listener to the store.
     * @param listener ReferencesStoreListener
     */
    void addListener(ReferencesStoreListener listener);

    /**
     * Removes a listener from the store.
     * @param listener ReferencesStoreListener
     */
    void removeListener(ReferencesStoreListener listener);

    String getCurrentDataset();

}
