/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/4/12
 * Time: 2:12 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
@Aspect
public class ErrorLoggerAspect {

    // @Before("de.kobv.mable.mab.extension.DatasetErrorStatistics.logError(*)")
    @Pointcut("execution(* de.kobv.mable.mab.extension.DatasetErrorStatistics.logError(*))")
    public void logError(DatasetError error) {
        System.out.println("Logging error: " + error);
    }

    // @Before("de.kobv.mable.mab.extension.DatasetErrorStatistics.logError(*,String)")
    @Pointcut("execution(* de.kobv.mable.mab.extension.DatasetErrorStatistics.logError(*, String))")
    public void logError(DatasetError error, String message) {
        System.out.println("Logging error: " + error);
    }

}
