/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Manages dynamic error codes for modules currently used for reports.
 *
 * This class is a factory for error codes and makes sure that dynamically
 * generated codes do not collide with each other and with the constants in
 * ErrorCode.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO make thread-safe
 * TODO improve design
 */
public class ErrorCodeManager {

    private int codeBase = 5000;

    private int lastCode = -1;

    private Map<Integer, Integer> errorCodes = new HashMap<Integer, Integer>();

    /**
     * Generates a new error code.
     * @return
     */
    public int generateCode(int hash) {
        int errorCode = 0;

        if (errorCodes.containsKey(hash)) {
            return errorCodes.get(hash);
        }

        if (lastCode < 0) {
            lastCode = codeBase;
        }
        else {
            lastCode++;
        }

        do {
            errorCode = lastCode;

            try {
                registerCode(hash, errorCode);
            }
            catch (ErrorCodeAlreadyExistsException ex) {
                errorCode = 0;
                lastCode++;
            }
        }
        while (errorCode == 0);

        return errorCode;
    }

    /**
     * Register user defined error code.
     * @param errorCode
     *
     * TODO not thread-safe (does not matter right now though)
     * TODO handle/prevent two hashes with same errorCode
     *
     */
    public void registerCode(final int hash, final int errorCode) throws ErrorCodeAlreadyExistsException {
        Integer code = new Integer(errorCode);
        if (errorCodes.get(hash) != code) {
            if (errorCodes.values().contains(code)) {
                throw new ErrorCodeAlreadyExistsException();
            }
            else {
                errorCodes.put(hash, code);
            }
        }
    }

}
