/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.common;

import java.util.HashMap;
import java.util.Map;

/**
 * Stores properties local for current execution thread.
 *
 * This could be used if data is processed in parallel on multiple threads.
 * Currently this is not the case for Mable.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public final class MableProperties {

    /**
     *
     */
    private static final ThreadLocal < Map<String, Object> > PROPERTIES =
            new ThreadLocal < Map<String, Object> >() {
                @Override
                protected Map<String, Object> initialValue() {
                    return new HashMap<String, Object>();
                }
            };

    /**
     * Prevent instance of the class from being instantiated.
     */
    private MableProperties() {
    }

    /**
     * Set thread local property.
     * @param key Name of property
     * @param value Value of property
     */
    public static void setProperty(final String key, final Object value) {
        PROPERTIES.get().put(key, value);
    }

    /**
     * Retrieve value of thread local property.
     * @param key Name of property
     * @return Object value of property or null
     */
    public static Object getProperty(final String key) {
        return PROPERTIES.get().get(key);
    }

}
