/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.aleph;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab.parser.MabParser;
import java.io.*;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/**
 * Parser for Aleph Sequential files/streams.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO parse lines
 * TODO process values
 * TODO split Aleph fields into multiple MAB fields
 * TODO create easy way to see/configure all the special rules
 *
 * TODO MabFeld class cannot handle fields like "LOW" or "FMT"
 */
public class AlephSeqParser implements MabParser {

    private static final Logger LOG = Logger.getLogger(AlephSeqParser.class);

    private ContentHandler contentHandler;

    private enum State {
        NONE,
        IN_SATZ,
        IN_DOCUMENT
    }

    private State status = State.NONE;

    /**
     *
     * @param file
     * @throws FileNotFoundException
     * @throws IOException
     * @throws MableConfigurationException
     */
    public void parse(File file) throws FileNotFoundException, IOException,
            MableConfigurationException {
        BufferedReader reader = new BufferedReader(new FileReader(file));

        String line;

        Pattern pattern = Pattern.compile("^(\\d+) (.{4})  L (.*)");

        int datasetCount = 0;

        String datasetId = null;

        contentHandler.startParsing();
        status = State.IN_DOCUMENT;

        while ((line = reader.readLine()) != null) {
            // process line
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                LOG.debug(matcher.group(0));
                String packageId = matcher.group(1);
                LOG.debug(packageId);
                String feldId = matcher.group(2);
                LOG.debug(feldId);
                String feldValue = matcher.group(3);
                LOG.debug(feldValue);

                if ("LDR ".equals(feldId)) {
                    if (status == State.IN_SATZ) {
                        contentHandler.endSatz();
                    }
                    datasetCount++;
                    status = State.IN_SATZ;
                    MabSatzkennung kennung = new MabSatzkennung();
                    kennung.setValue(feldValue);
                    contentHandler.startSatz(kennung);
                }
                else if ("001 ".equals(feldId)) {
                    datasetId = feldValue;
                    // System.out.println(feldValue.substring(3));
                }

                // Unterfelder verarbeiten
                if (feldValue.contains("$$")) {
                }


                String feldkennung = feldId.substring(0, 2);
                char indikator = feldId.charAt(3);
                String inhalt = feldValue;

                char unterfeldkennzeichen = ' ';
                String content = null;

                contentHandler.startFeld(feldkennung, indikator, inhalt);
                contentHandler.startUnterfeld(unterfeldkennzeichen, content);
            }
        }

        if (status == State.IN_SATZ) {
            contentHandler.endSatz();
        }

        contentHandler.endParsing();
    }

    public void parse(InputStream instream) {
    }

    public void parse(Reader reader) {


    }

    @Override
    public void setSource(Reader source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSource(InputStream stream) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse() throws IOException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDatasetsProcessed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDatasetsIgnored() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return contentHandler;
    }

}
