/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.kernels;

import de.kobv.mable.mab.parser.MabParser;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO document/cleanup
 * TODO generalize
 */
public class ProgressMonitor extends TimerTask {

    private MabParser parser;

    private int totalDatasets = 0;

    private long startTime = System.currentTimeMillis();

    private int processedBefore = 0;

    private int digits;

    @Override
    public void run() {
        int datasetsProcessed = parser.getDatasetsProcessed();

        int averageSpeed = datasetsProcessed - processedBefore;
        processedBefore = datasetsProcessed;

        String output = null;

        if (totalDatasets > 0) {
            int percentProcessed = (datasetsProcessed * 100) / totalDatasets;

            long timeUsed = System.currentTimeMillis() - startTime;

            int datasetsRemaining = totalDatasets - datasetsProcessed;

            long timeLeft = 0;

            try {
                timeLeft = timeUsed * datasetsRemaining
                        / datasetsProcessed / 1000;
            }
            catch (ArithmeticException e) {
                timeLeft = 0;
            }

            String timeLeftStr = formatTimeLeft(timeLeft);

            output = String.format("Processing: %1$" + digits
                    + "d (%2$3d %%) %3$5d datasets/s [ETA " + timeLeftStr + "]",
                datasetsProcessed, percentProcessed, averageSpeed);
        }
        else {
            output = String.format("Processing: %1$10d [%2$d datasets/s]",
                datasetsProcessed, averageSpeed);
        }

        output = StringUtils.rightPad(output, 79);
        System.out.print("\r" + output);
    }

    public void finish() {
        System.out.print(StringUtils.rightPad("\r", 79, " ") + "\r");
    }

    public MabParser getParser() {
        return parser;
    }

    public void setParser(final MabParser mabParser) {
        this.parser = mabParser;
    }

    public long getTotalDatasets() {
        return totalDatasets;
    }

    public void setTotalDatasets(final int total) {
        this.totalDatasets = total;
        digits = Integer.toString(this.totalDatasets).length();
    }

    protected String formatTimeLeft(final long time) {
        long sec = time % 60;
        long min = (time / 60) % 60;
        long hours = (time / 60 / 60) % 60;

        StringBuilder output = new StringBuilder();

        if (hours > 0) {
            output.append(String.format("%1$02dh", hours));
        }

        if (min > 0) {
            output.append(String.format("%1$02dm", min));
        }

        output.append(String.format("%1$02ds", sec));

        return output.toString();
    }

}
