/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import de.kobv.mable.util.ErrorCodeIndexReportParser;
import de.kobv.mable.util.SatzfehlerStatistics;
import de.kobv.mable.util.SubsetSatzfehlerStatistics;
import org.apache.log4j.Logger;

import java.io.*;
import java.util.Collection;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/5/12
 * Time: 2:25 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class AnalyseErrorsCommand extends AbstractMableCommand {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(AnalyseErrorsCommand.class);

    /**
     * Execute filtering.
     */
    @Override
    public void execute() {
        String filename = getFilename();

        File file = new File(filename);

        // TODO error handling (missing file)
        if (file.exists() && file.isFile()) {
        }
        else {

        }

        try {
            Reader source = new FileReader(getFilename());

            SatzfehlerStatistics statistics = new SatzfehlerStatistics();

            statistics.parse(source);

            Map<Integer, Integer> result = statistics.getNumberOfDatasetsWithErrorCount();

            PrintWriter writer = System.console().writer();

            int digitsForFehler = digitsOfBiggestValue(result.keySet());

            writer.println("Fehler -> Sätze");
            for(Map.Entry<Integer, Integer> entry : result.entrySet()) {
                writer.println(String.format("%1$" + digitsForFehler + "d -> %2$d", entry.getKey(), entry.getValue()));
            }
            writer.println();

            // Details
            SubsetSatzfehlerStatistics subset = new SubsetSatzfehlerStatistics();

            subset.setErrorsForDataset(statistics.getErrorsForDataset());
            subset.parse(new FileReader(getFilename()));

            String codesFilename = getCodesFilename(getFilename());

            ErrorCodeIndexReportParser codeParser = new ErrorCodeIndexReportParser();

            // TODO check existence of file

            codeParser.parse(new FileReader(codesFilename));

            for(Map.Entry<Integer, Integer> entry : result.entrySet()) {
                if (entry.getKey() == 1) {
                    writer.println("Sätze mit einem Fehler");
                }
                else {
                    writer.println("Sätze mit " + entry.getKey() + " Fehlern");
                }

                Map<String, Integer> details = subset.getErrorsForDatasets(entry.getKey());
                writer.println(" Anzahl -> Fehler");
                for (Map.Entry<String, Integer> fehlerEntry : details.entrySet()) {
                    String message = codeParser.getMessageForCode(fehlerEntry.getKey());
                    digitsForFehler = digitsOfBiggestValue(details.values());
                    writer.println(String.format("  %1$" + digitsForFehler + "d -> (#%2$s) %3$s", fehlerEntry.getValue(),
                            fehlerEntry.getKey(), message));
                }
                writer.println();
            }
        }
        catch (FileNotFoundException fnfe) {
            // TODO do something
        }
        catch (IOException ioe) {
            // TODO do something
        }
    }

    protected int digitsOfBiggestValue(Collection<Integer> values) {
        int biggestValue = 0;
        for(Integer value : values) {
            if (value > biggestValue) {
                biggestValue = value;
            }
        }
        return Integer.toString(biggestValue).length();
    }

    protected String getCodesFilename(String filename) {
        return filename.substring(0, filename.length() - 11) + "-codes.txt";
    }

}
