/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.util.Locale;
import java.util.ResourceBundle;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class XmlResourceBundleTest {

    @Test
    public void testLoadingXmlBundle() {
        ResourceBundle bundle = XmlResourceBundle.getBundle("messages",
                new XmlResourceBundleControl());

        assertNotNull(bundle.getString("message1"));
        assertEquals("Deutsch", bundle.getString("deutsch"));
        assertEquals("English", bundle.getString("english"));
    }

    @Test
    public void testLoadingXmlBundleForGerman() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages",
                Locale.GERMAN, new XmlResourceBundleControl());

        assertEquals("Test English", bundle.getString("message1"));
        assertEquals("Deutsch", bundle.getString("deutsch"));
        assertEquals("English", bundle.getString("english"));
    }

    @Test
    public void testLoadingXmlBundleForEnglish() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages",
                Locale.ENGLISH, new XmlResourceBundleControl());

        assertEquals("Test English", bundle.getString("message1"));
        assertEquals("Deutsch", bundle.getString("deutsch"));
        assertEquals("English", bundle.getString("english"));
    }

    /**
     * Test loading locale without resources.
     *
     * The system default and the base resources are loaded.
     */
    @Test
    public void testLoadingXmlBundleForFrench() {
        Locale locale = Locale.getDefault();

        Locale.setDefault(Locale.ENGLISH);

        ResourceBundle bundle = ResourceBundle.getBundle("messages",
                Locale.FRENCH, new XmlResourceBundleControl());

        assertEquals(Locale.ENGLISH, bundle.getLocale());
        assertEquals("Test English", bundle.getString("message1"));
        assertEquals("Deutsch", bundle.getString("deutsch"));
        assertEquals("English", bundle.getString("english"));
        assertFalse(bundle.containsKey("italian"));

        Locale.setDefault(locale);
    }

    /**
     * Test loading locale.
     *
     * The resources from Locale.ENGLISH are not present. The default resources
     * are loaded.
     */
    @Test
    public void testLoadingXmlBundleForItalian() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages",
                Locale.ITALIAN, new XmlResourceBundleControl());

        assertEquals("Test Deutsch", bundle.getString("message1"));
        assertEquals("Deutsch", bundle.getString("deutsch"));
        assertFalse(bundle.containsKey("english"));
        assertEquals("Italian", bundle.getString("italian"));
    }

}
