/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports.log4j;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.handler.ReportWriterFactory;
import java.io.IOException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO this isn't good yet
 * TODO why use Log4j for reports at all?
 * TODO How to generate XML reports? Separate report data from formatting?
 */
public class Log4jReportWriterFactory implements ReportWriterFactory {

    private static final Logger LOG =
            Logger.getLogger(Log4jReportWriterFactory.class);

    public Logger getReportWriter(final String name, final String loggerName,
            final String timestamp, final String suffix) throws IOException {
        Logger logger = Logger.getLogger(loggerName);

        String filename = name + "_" + timestamp + suffix;

        FileAppender appender = new FileAppender(
                new PatternLayout("%m%n"), filename, false);
        appender.activateOptions();

        logger.setAdditivity(false);
        logger.setLevel(Level.INFO);
        logger.addAppender(appender);

        LOG.info("Datei (" + filename + ") angelegt.");

        MableProperties.setProperty("report." + loggerName, filename);

        return logger;
    }

    public String getFilename() {
        return null;
    }

}
