/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports;

import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab2.modules.IsbnErrorType;
import de.kobv.mable.mab2.modules.IsbnStatistics;
import org.apache.log4j.Logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/5/12
 * Time: 12:33 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class IsbnReport extends SatzfehlerReport implements IsbnStatistics {

    /**
     * Map von gefundenen Fehlern in inkorrekten ISBN Einträgen.
     */
    private Map<IsbnErrorType.Reason, Integer> errorTypes = new EnumMap<IsbnErrorType.Reason, Integer>(
            IsbnErrorType.Reason.class);


    @Override
    public void generate() {
        Logger report = getReport();

        Map<ErrorType, Integer> result = getResult();

        StringWriter strOut = new StringWriter();

        PrintWriter out = new PrintWriter(strOut);

        out.println();
        out.println("--- ISBN Fehler (MAB 540) ---");
        out.println();

        if (result.isEmpty()) {
            out.println("Es wurden keine ISBN Fehler gefunden.");
        }
        else {
            out.println(" Anzahl -> Fehlermeldung");
            int maxDigits = getRequiredDigitsForValues(result.values());

            for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
                ErrorType errorType = entry.getKey();

                if (errorType instanceof IsbnErrorType) {
                    out.println(String.format("  %1$" + maxDigits + "d -> (#%2$d) %3$s", entry.getValue(),
                            errorType.getCode(), getErrorMessage(errorType)));
                }
            }

            out.println();
            out.println(" Mögliche Gründe für inkorrekte ISBNs in 540a");

            maxDigits = getRequiredDigitsForValues(errorTypes.values());

            for (Map.Entry<IsbnErrorType.Reason, Integer> entry : errorTypes.entrySet()) {
                out.println(String.format("  %1$" + maxDigits + "d -> %2$s", entry.getValue(),
                        entry.getKey().getMessage()));
            }
        }

        report.info(strOut.toString());
    }

    public void addInvalidIsbnReasons(Set<IsbnErrorType.Reason> reasons) {
        for (IsbnErrorType.Reason reason : reasons) {
            if (errorTypes.containsKey(reason)) {
                errorTypes.put(reason, errorTypes.get(reason) + 1);
            }
            else {
                errorTypes.put(reason, 1);
            }
        }
    }

    protected int getRequiredDigitsForValues(Collection<Integer> values) {
        int maxValue = 0;

        for (Integer value : values) {
            if (value > maxValue) {
                maxValue = value;
            }
        }

        return Integer.toString(maxValue).length();
    }

}
