/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.reports;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

import de.kobv.mable.mab2.modules.FieldStatistics;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO refactor! Nach Möglichkeit keine direkte Abhängigkeit von einem Modul.
 */
public class FieldStatisticsReport extends AbstractReport {

    private FieldStatistics fieldStatistics;

    /**
     * TODO align arrows
     * TODO align numbers
     * TODO use resource bundle
     */
    @Override
    public void generate() {
        Logger report = getReport();

        Map<String, Integer> feldStatistik = getData();

        StringWriter strOut = new StringWriter();
        PrintWriter out = new PrintWriter(strOut);
        out.println();
        out.println(getHeader());
        out.println();
        out.println(getMessages().getString(getMessageKey())); // this.message
        out.println();
        out.println(getHorizontalRule());
        out.println(" Feld -> Anzahl");
        out.println(getHorizontalRule());

        for (Map.Entry<String, Integer> entry : feldStatistik.entrySet()) {
            out.println(" " + entry.getKey() + " -> " + entry.getValue().toString());
        }

        out.println(getHorizontalRule());
        out.close();

        report.info(strOut.toString());
    }

    public Map<String, Integer> getData() {
        return getFieldStatistics().getFieldCount();
    }

    public FieldStatistics getFieldStatistics() {
        return fieldStatistics;
    }

    @Autowired(required=true)
    public void setFieldStatistics(FieldStatistics fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
    }

}
